//
//  BISearchResultItem.h
//  BISubstrate
//
//  Created by Fraser Kuyvenhoven on 11/06/08.
//  Copyright 2008 Marketcircle. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class BIClient;
@class BIQueryHandler;

@interface BISearchResultItem : NSObject
{
	id object;
	
	NSString* name;
	NSString* fieldMatched;
	int fieldImportance;
	NSString* fieldValue;
	NSRange matchRange;
	BOOL matchInName;
	NSMutableArray* pathStrings;
}

+ (BISearchResultItem *)searchResultItemWithObject:(id)anObject keyMatched:(NSString *)key searchString:(NSString *)searchStr importance:(int)imp queryHandler:(BIQueryHandler *)qh;

- (id)initWithObject:(id)anObject keyMatched:(NSString *)key searchString:(NSString *)searchStr importance:(int)imp queryHandler:(BIQueryHandler *)qh;

- (NSString *)nameForObject:(id)object;
- (NSString *)keyWithNameForObject:(id)object;	
- (NSArray *)pathForObject:(id)object;
- (NSString *)fieldMatchedForObject:(id)anObject key:(NSString *)key queryHandler:(BIQueryHandler *)qh;

- (id)object;
- (void)setObject:(id)anObject;

- (NSString *)name;
- (void)setName:(NSString *)aName;

- (NSString *)fieldMatched;
- (void)setFieldMatched:(NSString *)aFieldMatched;

- (int)fieldImportance;
- (void)setFieldImportance:(int)aFieldImportance;

- (NSString *)fieldValue;
- (void)setFieldValue:(NSString *)aFieldValue;

- (NSRange)matchRange;
- (void)setMatchRange:(NSRange)aMatchRange;

- (BOOL)matchInName;
- (void)setMatchInName:(BOOL)aMatchInName;

- (NSArray *)pathStrings;
- (void)setPathStrings:(NSArray *)aPathStrings;

@end
